﻿using System;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace SocketServer
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 13-27. Kompletna usługa informująca o bieżącym czasie
            // Listing 13-25. Nasłuchiwanie przychodzących połączeń TCP
            using (Socket daytimeListener = new Socket(
                AddressFamily.InterNetworkV6,
                SocketType.Stream,
                ProtocolType.Tcp))
            {
                daytimeListener.SetSocketOption(
                    SocketOptionLevel.IPv6, (SocketOptionName) 27, 0);

                IPEndPoint daytimeEndpoint = new IPEndPoint(IPAddress.IPv6Any, 13);
                daytimeListener.Bind(daytimeEndpoint);
                daytimeListener.Listen(20);

                // Listing 13-26. Akceptowanie połączeń przychodzących
                while (true)
                {
                    Socket incomingConnection = daytimeListener.Accept();
                    using (NetworkStream connectionStream =
                                        new NetworkStream(incomingConnection, true))
                    using (StreamWriter writer = new StreamWriter(connectionStream))
                    {
                        writer.WriteLine(DateTime.Now);
                    }
                }
            }
        }
    }
}